definition module StdMenuElement


//	********************************************************************************
//	Clean Standard Object I/O library, version 1.1
//	
//	StdMenuElement specifies all functions on menu elements.
//	Changing the status of menu elements requires a *MState.
//	Reading  the status of menu elements requires a  MState.
//	********************************************************************************


import	StdMenuDef
from	iostate	import IOSt


::	MState


getMenu :: !Id !(IOSt .l .p) -> (!Maybe MState, !IOSt .l .p)
/*	getMenu returns a read-only MState for the indicated menu.
	In case the indicated menu does not exist Nothing is returned.
*/


setMenu :: !Id ![IdFun *MState] !(IOSt .l .p) -> IOSt .l .p
/*	Apply the menu element changing functions to the current state of the indicated 
	menu. 
	In case the indicated menu does not exist nothing happens.
*/


/*	Functions that change the state of menu elements.
	When applied to unknown Ids none of these functions have effect.
*/

enableMenuElements  :: ![Id] !*MState -> *MState
disableMenuElements	:: ![Id] !*MState -> *MState
/*	(en/dis)ableMenuElements set the SelectState of the indicated menu elements.
	Disabling a (Sub/Radio)Menu overrules the SelectStates of its elements, which 
		become unselectable.
	Enabling a disabled (Sub/Radio)Menu re-establishes the SelectStates of its 
		elements.
	(En/Dis)able operations on the elements of a disabled (Sub/Radio)Menu take 
		effect when the (Sub/Radio)Menu is re-enabled.
*/

setMenuElementTitles :: ![(Id,Title)] !*MState -> *MState
/*	setMenuElementTitles sets the titles of the indicated menu elements.
*/

markMenuItems   :: ![Id] !*MState -> *MState
unmarkMenuItems	:: ![Id] !*MState -> *MState
/*	(un)markMenuItems sets the MarkState of the indicated MenuItems. 
*/

selectRadioMenuItem      :: !Id !Id    !*MState -> *MState
selectRadioMenuIndexItem :: !Id !Index !*MState -> *MState
/*	selectRadioMenu(Index)Item
		selects the indicated MenuRadioItem of a RadioMenu, causing the mark of the 
		previously marked MenuRadioItem to disappear. 
	selectRadioMenuItem 
		indicates the MenuRadioItem by the Id of its parent RadioMenu and its Id.
	selectRadioMenuIndexItem 
		indicates the MenuRadioItem by the Id of its parent RadioMenu and its index 
		position (counted from 1).
*/


/*	Functions that read the state of menu elements.
*/

getMenuElementTypes         ::     !MState -> [(MenuElementType,Maybe Id)]
getCompoundMenuElementTypes :: !Id !MState -> [(MenuElementType,Maybe Id)]
/*	getMenuElementTypes
		yields the list of MenuElementTypes of all menu elements of this menu. 
	getCompoundMenuElementTypes
		yields the list of MenuElementTypes of all menu elements of this 
		(Sub/Radio)Menu.
	Both functions return (Just id) if the element has a MenuId attribute, and 
	Nothing otherwise. 
	Ids are not collected recursively through (Sub/Radio)Menus.
*/

getSelectedRadioMenuItem	:: !Id   !MState -> (!Index,!Maybe Id)
/*	getSelectedRadioMenuItem
		returns the Index and Id, if any, of the currently selected MenuRadioItem of
		the indicated RadioMenu. 
	If the RadioMenu does not exist or is empyt, the Index is zero and the Id is 
	Nothing.
*/

getMenuElementSelectStates	:: ![Id] !MState -> [(Bool,SelectState)]	// Able
getMenuElementMarkStates	:: ![Id] !MState -> [(Bool,MarkState)]		// NoMark
getMenuElementTitles		:: ![Id] !MState -> [(Bool,Maybe String)]	// Nothing
getMenuElementShortKey		:: ![Id] !MState -> [(Bool,Maybe Char)]		// Nothing
/*	The  result list is of equal length as the argument Id list. 
	Each result list element corresponds in order with the argument Id list. 
	Of each element the first Boolean result is False in case of invalid id 
		(if so dummy values are returned - see comment).
	-	getMenuElementSelectStates
			yield the SelectState of the indicated elements. 
	-	getMenuElementMarkStates
			yield the MarkState of the indicated elements.
	-	getMenuElementTitles
			yields (Just title) of the indicated (SubMenu/MenuItem), 
			Nothing otherwise.
	-	getMenuElementShortKey
			yields (Just key) of the indicated MenuItem, Nothing otherwise.
*/
